

<?php $__env->startSection('title', 'Servers'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Servers</h1>
            <a href="<?php echo e(route('admin.servers.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Server
            </a>
        </div>
        <p>Manage your game servers</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Server List</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Address</th>
                            <th>App ID</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($server->name); ?></td>
                            <td><?php echo e($server->ip); ?>:<?php echo e($server->port); ?></td>
                            <td><?php echo e($server->app_id); ?></td>
                            <td>
                                <?php if($server->is_active): ?>
                                <span class="server-status-badge online">
                                    <i class="fas fa-circle"></i> Active
                                </span>
                                <?php else: ?>
                                <span class="server-status-badge offline">
                                    <i class="fas fa-circle"></i> Inactive
                                </span>
                                <?php endif; ?>
                            </td>
                            <td class="user-actions">
                                <a href="<?php echo e(route('admin.servers.show', $server->id)); ?>" class="btn-icon btn-primary" title="View Server">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.servers.edit', $server->id)); ?>" class="btn-icon btn-info" title="Edit Server">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('admin.servers.destroy', $server->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this server?');" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-icon btn-danger" title="Delete Server">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">No servers found.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/servers/index.blade.php ENDPATH**/ ?>